/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_QoSSet;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import java.util.ArrayList;

public abstract class TLV_ServiceFlow
extends SubTypedTLV {
    public static final int REFERENCE = 1;
    public static final int IDENTIFIER = 2;
    public static final int CLASSNAME = 4;
    public static final int ASF_QOS_PROFILE_NAME = 4;
    public static final int QoS_PARAMETER_SET = 6;
    public static final int TRAFFIC_PRIORITY = 7;
    public static final int UPSTREAM_MAX_SUSTAINED_TRAFFIC_RATE = 8;
    public static final int DOWNSTREAM_MAX_SUSTAINED_TRAFFIC_RATE = 8;
    public static final int MAXIMUM_TRAFFIC_BURST = 9;
    public static final int MINIMUM_RESERVED_TRAFFIC_RATE = 10;
    public static final int ASSUMED_MINIMUM_RESERVED_RATE_PACKET_SIZE = 11;
    public static final int TIMEOUT_FOR_ACTIVE_QOS_PARAMETERS = 12;
    public static final int TIMEOUT_FOR_ADMITTED_QOS_PARAMETERS = 13;
    public static final int MAXIMUM_CONCATENATED_BURST = 14;
    public static final int MAXIMUM_DOWNSTREAM_LATENCY = 14;
    public static final int SCHEDULING_TYPE = 15;
    public static final int REQUEST_TRANSMISSION_POLICY = 16;
    public static final int NOMINAL_POLLING_INTERVAL = 17;
    public static final int DOWNSTREAM_RESEQUENCING = 17;
    public static final int TOLERATED_POLL_JITTER = 18;
    public static final int UNSOLICITED_GRANT_SIZE = 19;
    public static final int NOMINAL_GRANT_INTERVAL = 20;
    public static final int TOLERATED_GRANT_JITTER = 21;
    public static final int GRANTS_PER_INTERVAL = 22;
    public static final int IP_TYPE_OF_SERVICE_OVERWRITE = 23;
    public static final int UNSOLICITED_GRANT_TIME_REFERENCE = 24;
    public static final int MULTIPLIER_TO_CONTENTION_REQUEST = 25;
    public static final int MULTIPLIER_TO_NUMBER_OF_BYTES_REQUESTED = 26;
    public static final int UPSTREAM_PEAK_TRAFFIC_RATE = 27;
    public static final int DOWNSTREAM_PEAK_TRAFFIC_RATE = 27;
    public static final int REQUIRED_ATTRIBUTE_MASK = 31;
    public static final int FORBIDDEN_ATTRIBUTE_MASK = 32;
    public static final int ATTRIBUTE_AGGREGATION_RULE_MASK = 33;
    public static final int APPLICATION_ID = 34;
    public static final int BUFFER_CONTROL = 35;
    public static final int AGGREGATE_SF_REFERENCE = 36;
    public static final int MESP_REFERENCE = 37;
    public static final int SERVICE_FLOW_MATCHING_CRITERIA = 38;
    public static final int TO_IATC_PROFILE_NAME_REFERENCE = 39;
    public static final int AQM_ENCODINGS = 40;
    public static final int DATA_RATE_UNIT_SETTING = 41;
    public static final int LOW_LATENCY_AGGREGATE_SF_ENCODINGS = 42;
    public static final int VENDOR_SPECIFIC = 43;
    public static final int GUARANTEED_GRANT_INTERVAL = 44;
    public static final int GUARANTEED_GRANT_RATE = 45;
    public static final int GUARANTEED_REQUEST_INTERVAL = 46;
    public static final int ENHANCED_HQOS_INTRA_ASF_SCHEDULING_ENCODING = 47;
    public static final int ABSOLUTE_QUEUE_DEPTH_REQUEST_ENABLE = 48;
    public static final int PGS_ACTIVITY_DETECTION_DISABLE = 49;
    private ConfigFile itsConfigFile = null;

    public void setConfigFile(ConfigFile cfg) {
        this.itsConfigFile = cfg;
    }

    public ConfigFile getConfigFile() {
        return this.itsConfigFile;
    }

    public int getReference() throws Exception {
        ArrayList<ISubTLV> subs = this.getSubTypeTLVs(1);
        if (subs.size() == 0) {
            return -1;
        }
        if (subs.size() > 1) {
            throw new Exception("Error: multiple SF references found on a single service flow object!");
        }
        SF_Reference ref = (SF_Reference)subs.iterator().next();
        return ref.getReference();
    }

    public boolean[] getQosSettings() throws Exception {
        ArrayList<ISubTLV> subs = this.getSubTypeTLVs(6);
        if (subs.size() == 0) {
            return new boolean[3];
        }
        if (subs.size() > 1) {
            throw new Exception("Error: multiple QoS references found on a single service flow object!");
        }
        SF_QoSSet ref = (SF_QoSSet)subs.iterator().next();
        boolean[] ret = new boolean[]{ref.getProvisioned(), ref.getAdmitted(), ref.getActive()};
        return ret;
    }
}

