/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.SNMPV3_PublicNumber;
import com.excentis.security.configfile.tlvs.tlvsub1types.SNMPV3_SecurityName;
import java.util.ArrayList;

public class TLV_SnmpV3KickStart
extends SubTypedTLV {
    public static final String typeInfo = "Snmp V3 Kickstart Value";
    public static final String fullTypeInfo = "Snmp V3 Kickstart Value".concat(" (34)");
    public static final int SECURITY_NAME = 1;
    public static final int PUBLIC_NUMBER = 2;
    public static int COUNT = 0;

    public TLV_SnmpV3KickStart(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(34);
        ++COUNT;
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_SnmpV3KickStart(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(34);
        int totalLength = encodedSubTypes.length;
        ++COUNT;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new SNMPV3_SecurityName(this, new String(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new SNMPV3_PublicNumber(this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

