/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.IIpv6ListTlv;
import com.excentis.security.configfile.panels.basic.Ipv6AddressListPanel;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TLV_SubCPEIPv6List
extends TLV
implements IIpv6ListTlv {
    public static final String typeInfo = "Subscriber Mgmt CPE IPv6 List";
    public static final String fullTypeInfo = "Subscriber Mgmt CPE IPv6 List".concat(" (67)");

    private void initialize(byte[] value) throws UnsupportedTypeException, InvalidLengthException {
        this.setType(67);
        this.setData(value);
    }

    public TLV_SubCPEIPv6List(ArrayList<Inet6Address> addresses) throws InvalidLengthException, UnsupportedTypeException {
        this.initialize(this.getBytesFromIpv6Addresses(addresses));
    }

    public TLV_SubCPEIPv6List(byte[] value) throws Exception {
        this.initialize(value);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        String result = "";
        for (InetAddress inetAddress : this.getAddresses()) {
            result = result.concat(inetAddress.getHostAddress() + " ");
        }
        return result;
    }

    @Override
    public void setAddresses(ArrayList<Inet6Address> addresses) throws InvalidLengthException {
        this.setData(this.getBytesFromIpv6Addresses(addresses));
    }

    @Override
    public ArrayList<Inet6Address> getAddresses() {
        ArrayList<Inet6Address> addresses = null;
        try {
            addresses = this.getIpv6AddressesFromBytes(this.getValue());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (InvalidLengthException e) {
            e.printStackTrace();
        }
        return addresses;
    }

    @Override
    public JPanel showGUI() {
        return new Ipv6AddressListPanel(this);
    }
}

