/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.MaxSubControlException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.SubControlPanel;
import javax.swing.JPanel;

public class TLV_SubControl
extends TLV {
    public static final String typeInfo = "Subscriber Management Control";
    public static final String fullTypeInfo = "Subscriber Management Control".concat(" (35)");
    private int itsMaxCPEIP = 0;
    private boolean isActive = false;
    private boolean isLearnable = false;

    public TLV_SubControl(int maxCPEIP, boolean active, boolean learn) throws InvalidLengthException, UnsupportedTypeException, MaxSubControlException {
        this.checkConstraints(maxCPEIP);
        this.setType(35);
        this.setData(TLV_SubControl.encode(maxCPEIP, active, learn));
        this.itsMaxCPEIP = maxCPEIP;
        this.isActive = active;
        this.isLearnable = learn;
    }

    public TLV_SubControl(byte[] value) throws Exception {
        if (value.length != 3) {
            throw new InvalidLengthException(typeInfo);
        }
        byte[] cpeip = new byte[]{value[0], value[1]};
        int maxCPE = this.getIntFromBytes(cpeip);
        this.checkConstraints(maxCPE);
        this.itsMaxCPEIP = maxCPE;
        this.isActive = value[2] % 2 == 1;
        this.isLearnable = value[2] / 2 % 2 == 1;
        this.setType(35);
        this.setData(TLV_SubControl.encode(this.itsMaxCPEIP, this.isActive, this.isLearnable));
    }

    @Override
    public String getShowValue() {
        return "" + this.itsMaxCPEIP + " address permitted, " + (this.getActive() ? "active, " : "inactive, ") + (this.getLearnable() ? "learnable" : "not learnable");
    }

    private void checkConstraints(int maxCPE) throws MaxSubControlException {
        if (maxCPE < 0) {
            throw new MaxSubControlException();
        }
        if (maxCPE > 1023) {
            throw new MaxSubControlException();
        }
    }

    public void setMaxCPEIP(int maxCPEIP) throws MaxSubControlException, InvalidLengthException {
        this.checkConstraints(maxCPEIP);
        this.setData(TLV_SubControl.encode(maxCPEIP, this.isActive, this.isLearnable));
        this.itsMaxCPEIP = maxCPEIP;
    }

    public boolean getLearnable() {
        return this.isLearnable;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void setLearnable(boolean learn) throws InvalidLengthException {
        this.isLearnable = learn;
        this.setData(TLV_SubControl.encode(this.itsMaxCPEIP, this.isActive, this.isLearnable));
    }

    public void setActive(boolean act) throws InvalidLengthException {
        this.isActive = act;
        this.setData(TLV_SubControl.encode(this.itsMaxCPEIP, this.isActive, this.isLearnable));
    }

    public int getMaxCPEIP() {
        return this.itsMaxCPEIP;
    }

    private static byte[] encode(int i, boolean act, boolean learn) {
        byte[] result = new byte[3];
        result[0] = (byte)(i / 256);
        result[1] = (byte)(i % 256);
        result[2] = learn ? (act ? 3 : 2) : (act ? 1 : 0);
        return result;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new SubControlPanel(this);
    }
}

