/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.SubGroupsPanel;
import javax.swing.JPanel;

public class TLV_SubGroups
extends TLV {
    public static final String typeInfo = "Subscriber Management Filter Groups";
    public static final String fullTypeInfo = "Subscriber Management Filter Groups".concat(" (37)");
    private int SubDown = 0;
    private int SubUp = 0;
    private int CmDown = 0;
    private int CmUp = 0;
    private int PsDown = 0;
    private int PsUp = 0;
    private int MtaDown = 0;
    private int MtaUp = 0;
    private int StbDown = 0;
    private int StbUp = 0;
    private boolean extended = false;

    public TLV_SubGroups(int sd, int su, int cd, int cu) throws InvalidLengthException, UnsupportedTypeException, Exception {
        this.checkConstraints(sd, su, cd, cu);
        this.setType(37);
        this.setData(TLV_SubGroups.encode(sd, su, cd, cu));
        this.SubDown = sd;
        this.SubUp = su;
        this.CmDown = cd;
        this.CmUp = cu;
        this.extended = false;
    }

    public TLV_SubGroups(int sd, int su, int cd, int cu, int pd, int pu, int md, int mu, int std, int stu) throws InvalidLengthException, UnsupportedTypeException, Exception {
        this.checkConstraints(sd, su, cd, cu);
        this.setType(37);
        this.setData(TLV_SubGroups.encode(sd, su, cd, cu));
        this.SubDown = sd;
        this.SubUp = su;
        this.CmDown = cd;
        this.CmUp = cu;
        this.PsDown = pd;
        this.PsUp = pu;
        this.MtaDown = md;
        this.MtaUp = mu;
        this.StbDown = std;
        this.StbUp = stu;
        this.extended = true;
    }

    public TLV_SubGroups(byte[] value) throws Exception {
        if (value.length == 8) {
            byte[] sd = new byte[]{value[0], value[1]};
            this.SubDown = this.getIntFromBytes(sd);
            byte[] su = new byte[]{value[2], value[3]};
            this.SubUp = this.getIntFromBytes(su);
            byte[] cd = new byte[]{value[4], value[5]};
            this.CmDown = this.getIntFromBytes(cd);
            byte[] cu = new byte[]{value[6], value[7]};
            this.CmUp = this.getIntFromBytes(cu);
            this.setType(37);
            this.setData(TLV_SubGroups.encode(this.SubDown, this.SubUp, this.CmDown, this.CmUp));
            this.extended = false;
        } else if (value.length == 20) {
            byte[] sd = new byte[]{value[0], value[1]};
            this.SubDown = this.getIntFromBytes(sd);
            byte[] su = new byte[]{value[2], value[3]};
            this.SubUp = this.getIntFromBytes(su);
            byte[] cd = new byte[]{value[4], value[5]};
            this.CmDown = this.getIntFromBytes(cd);
            byte[] cu = new byte[]{value[6], value[7]};
            this.CmUp = this.getIntFromBytes(cu);
            byte[] pd = new byte[]{value[8], value[9]};
            this.PsDown = this.getIntFromBytes(pd);
            byte[] pu = new byte[]{value[10], value[11]};
            this.PsUp = this.getIntFromBytes(pu);
            byte[] md = new byte[]{value[12], value[13]};
            this.MtaDown = this.getIntFromBytes(md);
            byte[] mu = new byte[]{value[14], value[15]};
            this.MtaUp = this.getIntFromBytes(mu);
            byte[] std = new byte[]{value[16], value[17]};
            this.StbDown = this.getIntFromBytes(std);
            byte[] stu = new byte[]{value[18], value[19]};
            this.StbUp = this.getIntFromBytes(stu);
            this.setType(37);
            this.setData(TLV_SubGroups.encode(this.SubDown, this.SubUp, this.CmDown, this.CmUp, this.PsDown, this.PsUp, this.MtaDown, this.MtaUp, this.StbDown, this.StbUp));
            this.extended = true;
        } else {
            throw new InvalidLengthException(typeInfo);
        }
    }

    public int getSubDown() {
        return this.SubDown;
    }

    public int getSubUp() {
        return this.SubUp;
    }

    public int getCmDown() {
        return this.CmDown;
    }

    public int getCmUp() {
        return this.CmUp;
    }

    public int getPsDown() {
        return this.PsDown;
    }

    public int getPsUp() {
        return this.PsUp;
    }

    public int getMtaDown() {
        return this.MtaDown;
    }

    public int getMtaUp() {
        return this.MtaUp;
    }

    public int getStbDown() {
        return this.StbDown;
    }

    public int getStbUp() {
        return this.StbUp;
    }

    private void checkConstraints(int a, int b, int c, int d) throws Exception {
        if (a < 0 || b < 0 || c < 0 || d < 0) {
            throw new Exception("Filter Group reference must be between 0 and 1024.");
        }
        if (a > 1024 || b > 1024 || c > 1024 || d > 1024) {
            throw new Exception("Filter Group reference must be between 0 and 1024.");
        }
    }

    private void checkConstraints(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j) throws Exception {
        if (a < 0 || b < 0 || c < 0 || d < 0 || e < 0 || f < 0 || g < 0 || h < 0 || i < 0 || j < 0) {
            throw new Exception("Filter Group reference must be between 0 and 1024.");
        }
        if (a > 1024 || b > 1024 || c > 1024 || d > 1024 || e > 1024 || f > 1024 || g > 1024 || h > 1024 || i > 1024 || j > 1024) {
            throw new Exception("Filter Group reference must be between 0 and 1024.");
        }
    }

    @Override
    public String getShowValue() {
        if (!this.extended) {
            return "CMupstream " + this.getCmUp() + ", CMdownstream " + this.getCmDown() + ", CPEupstream " + this.getSubUp() + ", CPEdownstream " + this.getSubDown();
        }
        return "CMupstream " + this.getCmUp() + ", CMdownstream " + this.getCmDown() + ", SUBupstream " + this.getSubUp() + ", SUBdownstream " + this.getSubDown() + ", PSupstream " + this.getPsUp() + ", PSdownstream " + this.getPsDown() + ", MTAupstream " + this.getMtaUp() + ", MTAdownstream " + this.getMtaDown() + ", STBupstream " + this.getStbUp() + ", STBdownstream " + this.getStbDown();
    }

    public void setValues(int sd, int su, int cd, int cu) throws Exception {
        this.checkConstraints(sd, su, cd, cu);
        this.setData(TLV_SubGroups.encode(sd, su, cd, cu));
        this.SubDown = sd;
        this.SubUp = su;
        this.CmDown = cd;
        this.CmUp = cu;
        this.extended = false;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extend) throws Exception {
        if (extend) {
            this.setValues(this.SubDown, this.SubUp, this.CmDown, this.CmUp, this.PsDown, this.PsUp, this.MtaDown, this.MtaUp, this.StbDown, this.StbUp);
        } else {
            this.setValues(this.SubDown, this.SubUp, this.CmDown, this.CmUp);
        }
    }

    public void setValues(int sd, int su, int cd, int cu, int pd, int pu, int md, int mu, int std, int stu) throws Exception {
        this.checkConstraints(sd, su, cd, cu, pd, pu, md, mu, std, stu);
        this.setData(TLV_SubGroups.encode(sd, su, cd, cu, pd, pu, md, mu, std, stu));
        this.SubDown = sd;
        this.SubUp = su;
        this.CmDown = cd;
        this.CmUp = cu;
        this.PsDown = pd;
        this.PsUp = pu;
        this.MtaDown = md;
        this.MtaUp = mu;
        this.StbDown = std;
        this.StbUp = stu;
        this.extended = true;
    }

    private static byte[] encode(int a, int b, int c, int d) {
        byte[] result = new byte[]{(byte)(a / 256), (byte)(a % 256), (byte)(b / 256), (byte)(b % 256), (byte)(c / 256), (byte)(c % 256), (byte)(d / 256), (byte)(d % 256)};
        return result;
    }

    private static byte[] encode(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j) {
        byte[] result = new byte[]{(byte)(a / 256), (byte)(a % 256), (byte)(b / 256), (byte)(b % 256), (byte)(c / 256), (byte)(c % 256), (byte)(d / 256), (byte)(d % 256), (byte)(e / 256), (byte)(e % 256), (byte)(f / 256), (byte)(f % 256), (byte)(g / 256), (byte)(g % 256), (byte)(h / 256), (byte)(h % 256), (byte)(i / 256), (byte)(i % 256), (byte)(j / 256), (byte)(j % 256)};
        return result;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new SubGroupsPanel(this);
    }
}

