/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.SubTablePanel;
import com.excentis.security.utils.CertUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class TLV_SubTable
extends TLV {
    public static final String typeInfo = "Subscriber Management CPE IP Table";
    public static final String fullTypeInfo = "Subscriber Management CPE IP Table".concat(" (36)");
    private ArrayList<InetAddress> itsAddresses = new ArrayList();

    public TLV_SubTable(ArrayList<InetAddress> addresses) throws InvalidLengthException, UnsupportedTypeException {
        this.itsAddresses = addresses;
        this.setType(36);
        this.setData(TLV_SubTable.encode(this.itsAddresses));
    }

    public TLV_SubTable(byte[] value) throws Exception {
        if (value.length % 4 != 0) {
            throw new InvalidLengthException(typeInfo);
        }
        for (int i = 0; i < value.length; i += 4) {
            int[] adres = new int[]{this.getIntFromBytes(new byte[]{value[i]}), this.getIntFromBytes(new byte[]{value[i + 1]}), this.getIntFromBytes(new byte[]{value[i + 2]}), this.getIntFromBytes(new byte[]{value[i + 3]})};
            this.itsAddresses.add(InetAddress.getByName("" + adres[0] + "." + adres[1] + "." + adres[2] + "." + adres[3]));
        }
        this.setType(36);
        this.setData(TLV_SubTable.encode(this.itsAddresses));
    }

    private static byte[] encode(ArrayList<InetAddress> l) {
        Iterator<InetAddress> it = l.iterator();
        byte[] result = null;
        while (it.hasNext()) {
            InetAddress adres = it.next();
            result = CertUtils.appendAt(result, adres.getAddress());
        }
        return result;
    }

    @Override
    public String getShowValue() {
        String result = "";
        for (InetAddress adr : this.itsAddresses) {
            result = result.concat(adr.getHostAddress() + " ");
        }
        return result;
    }

    public void setAddresses(ArrayList<InetAddress> l) throws InvalidLengthException {
        this.itsAddresses = l;
        this.setData(TLV_SubTable.encode(this.itsAddresses));
    }

    public ArrayList<InetAddress> getAddresses() {
        return this.itsAddresses;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new SubTablePanel(this);
    }
}

