/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.TimestampPanel;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;

public class TLV_TFTPTimestamp
extends TLV {
    public static final String typeInfo = "TFTP Server Timestamp";
    public static final String fullTypeInfo = "TFTP Server Timestamp".concat(" (19)");
    private GregorianCalendar itsDate = null;
    public static long secsFrom1900Till1970 = 2208988800L;

    public TLV_TFTPTimestamp(GregorianCalendar d) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(19);
        this.setData(this.encode(d));
        this.itsDate = d;
    }

    public TLV_TFTPTimestamp(byte[] val) throws InvalidLengthException, UnsupportedTypeException {
        this(TLV_TFTPTimestamp.getDateFromBytes(val));
    }

    private static GregorianCalendar getDateFromBytes(byte[] value) {
        byte[] val = new byte[value.length + 1];
        val[0] = 0;
        for (int i = 0; i < value.length; ++i) {
            val[i + 1] = value[i];
        }
        BigInteger big = new BigInteger(val);
        Date d = new Date(1000L * (big.longValue() - secsFrom1900Till1970));
        GregorianCalendar cal = new GregorianCalendar(1900 + d.getYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
        cal.add(12, d.getTimezoneOffset());
        return cal;
    }

    public void setDate(GregorianCalendar d) throws InvalidLengthException {
        this.setData(this.encode(d));
        this.itsDate = d;
    }

    public GregorianCalendar getDate() {
        return this.itsDate;
    }

    @Override
    public String getShowValue() {
        return "Year " + this.itsDate.get(1) + " Month " + (this.itsDate.get(2) + 1) + " Day " + this.itsDate.get(5) + " Hour " + this.itsDate.get(11) + " Min " + this.itsDate.get(12) + " Sec " + this.itsDate.get(13);
    }

    private byte[] encode(GregorianCalendar d) {
        int jaar = d.get(1);
        long seconds = 0L;
        if (jaar < 1900) {
            return new byte[4];
        }
        for (int i = 1900; i < jaar; ++i) {
            if (d.isLeapYear(i)) {
                seconds += 31622400L;
                continue;
            }
            seconds += 31536000L;
        }
        seconds += (long)((d.get(6) - 1) * 24 * 3600);
        seconds += (long)(d.get(11) * 3600);
        seconds += (long)(d.get(12) * 60);
        return this.encodeLong(seconds += (long)d.get(13));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new TimestampPanel(this);
    }
}

