/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_AdminStatus;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_AutoNegotiationStatus;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_ContextCMIM;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_Duplex;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_EEEStatus;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_MaximumFrameSize;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_MediaType;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_OperatingSpeed;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.UNI_POEStatus;
import java.util.ArrayList;

public class TLV_UNI_Encodings
extends SubTypedTLV {
    public static final String typeInfo = "Unidirectional (UNI) Control Encodings";
    public static final String fullTypeInfo = "Unidirectional (UNI) Control Encodings".concat(" (79)");
    public static final int CONTEXT_CMIM = 1;
    public static final int UNI_ADMIN_STATUS = 2;
    public static final int UNI_AUTONEGOTIATION_STATUS = 3;
    public static final int UNI_OPERATING_SPEED = 4;
    public static final int UNI_DUPLEX = 5;
    public static final int EEE_STATUS = 6;
    public static final int MAXIMUM_FRAME_SIZE = 7;
    public static final int POE_STATUS = 8;
    public static final int MEDIA_TYPE = 9;

    public TLV_UNI_Encodings(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(79);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_UNI_Encodings(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(79);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new UNI_ContextCMIM(this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new UNI_AdminStatus(this, this.getBooleanFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new UNI_AutoNegotiationStatus(this, this.getBooleanFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new UNI_OperatingSpeed(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new UNI_Duplex(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new UNI_EEEStatus(this, this.getBooleanFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new UNI_MaximumFrameSize(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 8) {
                sub = new UNI_POEStatus(this, this.getBooleanFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new UNI_MediaType(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

