/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class TLV_UpstreamChannelID
extends TLV
implements INumberTlv {
    private int itsID = 0;
    public static final String typeInfo = "Upstream Channel ID Configuration";
    public static final String fullTypeInfo = "Upstream Channel ID Configuration".concat(" (2)");

    public TLV_UpstreamChannelID(int channel) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        this.setType(2);
        this.setNumber(channel);
    }

    private void checkConstraints(int channel) throws InvalidNumberException {
        if (channel < 1) {
            throw new InvalidNumberException(this, 1, 255);
        }
        if (channel > 255) {
            throw new InvalidNumberException(this, 1, 255);
        }
    }

    @Override
    public void setNumber(int channel) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(channel);
        this.setData(this.encodeInt1(channel));
        this.itsID = channel;
    }

    @Override
    public int getNumber() {
        return this.itsID;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Upstream Channel ID:");
    }
}

