/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.UpstreamServiceFlowPanel;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AQMEncodings;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AbsoluteQueueDepthRequestEnable;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AggregateSFReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ApplicationIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AssumedMinimumReservedRatePacketSize;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AttributeAggregationRuleMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_BufferControl;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ClassName;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DataRateUnitSetting;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ExtensionField;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ForbiddenAttributeMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_GrantsPerInterval;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_GuaranteedGrantInterval;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_GuaranteedGrantRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_GuaranteedRequestInterval;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_IPToSOverwrite;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Identifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MESPReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MaxConcatenatedBurst;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MaxTrafficBurst;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MinimumReservedTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MultiplierToContentionRequestBackoffWindow;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MultiplierToNumberOfBytesRequested;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_NominalGrantInterval;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_NominalPollingInterval;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_PGSActivityDetectionDisable;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_QoSSet;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_RequestTransmissionPolicy;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_RequiredAttributeMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_SchedulingType;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TimeoutForActiveQoS;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TimeoutForAdmittedQoS;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ToIATCProfileNameReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ToleratedGrantJitter;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ToleratedPollJitter;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TrafficPriority;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_USMaxSustainedTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_UnsolicitedGrantSize;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_UnsolicitedGrantTimeReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_UpstreamPeakTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_VendorSpecific;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TLV_UpstreamServiceFlow
extends TLV_ServiceFlow {
    public static final String typeInfo = "Upstream Service Flow Encodings";
    public static final String fullTypeInfo = "Upstream Service Flow Encodings".concat(" (24)");

    public TLV_UpstreamServiceFlow(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws Exception {
        this.setConfigFile(cfg);
        this.setType(24);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_UpstreamServiceFlow(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        this.setConfigFile(cfg);
        this.setType(24);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            SubTLV sub2;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub2 = new SF_Reference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 2) {
                sub2 = new SF_Identifier(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 4) {
                sub2 = new SF_ClassName(this, this.decodeStringMinusLast(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 6) {
                boolean[] bool = this.getQoSBooleansFromByte(value);
                sub = new SF_QoSSet(this, bool[0], bool[1], bool[2]);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub2 = new SF_TrafficPriority(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 8) {
                sub2 = new SF_USMaxSustainedTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 9) {
                sub2 = new SF_MaxTrafficBurst(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 10) {
                sub2 = new SF_MinimumReservedTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 11) {
                sub2 = new SF_AssumedMinimumReservedRatePacketSize(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 12) {
                sub2 = new SF_TimeoutForActiveQoS(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 13) {
                sub2 = new SF_TimeoutForAdmittedQoS(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 43) {
                byte[] vendor = new byte[3];
                System.arraycopy(value, 2, vendor, 0, 3);
                if (vendor[0] == -1 && vendor[1] == -1 && vendor[2] == -1) {
                    this.getSubTLVs().add(new SF_ExtensionField(this, value));
                    continue;
                }
                this.getSubTLVs().add(new SF_VendorSpecific(this, value));
                continue;
            }
            if (type == 14) {
                sub2 = new SF_MaxConcatenatedBurst(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 15) {
                sub2 = new SF_SchedulingType(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 16) {
                boolean[] bools = this.getElevenBooleansFromBytes(value);
                sub = new SF_RequestTransmissionPolicy(this, bools[0], bools[1], bools[2], bools[3], bools[4], bools[5], bools[6], bools[7], bools[8], bools[9], bools[10]);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 17) {
                sub2 = new SF_NominalPollingInterval(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 18) {
                sub2 = new SF_ToleratedPollJitter(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 19) {
                sub2 = new SF_UnsolicitedGrantSize(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 20) {
                sub2 = new SF_NominalGrantInterval(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 21) {
                sub2 = new SF_ToleratedGrantJitter(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 22) {
                sub2 = new SF_GrantsPerInterval(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 23) {
                sub2 = new SF_IPToSOverwrite(this, value[0], value[1]);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 24) {
                sub2 = new SF_UnsolicitedGrantTimeReference(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 25) {
                sub2 = new SF_MultiplierToContentionRequestBackoffWindow(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 26) {
                sub2 = new SF_MultiplierToNumberOfBytesRequested(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 35) {
                sub2 = new SF_BufferControl((TLV)this, value);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 31) {
                sub2 = new SF_RequiredAttributeMask(this, value);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 32) {
                sub2 = new SF_ForbiddenAttributeMask(this, value);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 33) {
                sub2 = new SF_AttributeAggregationRuleMask(this, value);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 34) {
                sub2 = new SF_ApplicationIdentifier(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 36) {
                sub2 = new SF_AggregateSFReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 37) {
                sub2 = new SF_MESPReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 27) {
                sub2 = new SF_UpstreamPeakTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 39) {
                sub2 = new SF_ToIATCProfileNameReference(this, this.decodeStringMinusLast(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 40) {
                sub2 = new SF_AQMEncodings((TLV)this, value);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 41) {
                sub2 = new SF_DataRateUnitSetting(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 44) {
                sub2 = new SF_GuaranteedGrantInterval(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 45) {
                sub2 = new SF_GuaranteedGrantRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 46) {
                sub2 = new SF_GuaranteedRequestInterval(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 48) {
                sub2 = new SF_AbsoluteQueueDepthRequestEnable(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 49) {
                sub2 = new SF_PGSActivityDetectionDisable(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub2 = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add(sub2);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    public boolean[] getElevenBooleansFromBytes(byte[] b) {
        byte[] val = new byte[b.length + 1];
        val[0] = 0;
        for (int i = 0; i < b.length; ++i) {
            val[i + 1] = b[i];
        }
        BigInteger big = new BigInteger(val);
        int number = big.intValue();
        boolean[] bools = new boolean[]{number % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1, (number /= 2) % 2 == 1};
        return bools;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI(ConfigFileGUI gui) {
        return new UpstreamServiceFlowPanel(this, gui);
    }
}

