/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IVendorSpecificTlv;
import com.excentis.security.configfile.panels.VendorSpecificPanel;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import javax.swing.JPanel;

public class TLV_VendorSpecific
extends TLV
implements IVendorSpecificTlv {
    public static final String typeInfo = "Euro-DOCSIS vendor specific Extension Field";
    public static final String fullTypeInfo = "Euro-DOCSIS vendor specific Extension Field".concat(" (43)");
    private byte[] itsVendorId = null;
    private byte[] itsVendorData = null;

    public TLV_VendorSpecific(byte[] value) throws Exception {
        this.setType(43);
        if (value[0] != 8) {
            throw new Exception("Illegal Vendor ID, expected type 0x08, got " + value[0]);
        }
        if (value[1] != 3) {
            throw new Exception("Illegal Vendor ID length, expected 0x03, got " + value[1]);
        }
        if (value.length < 5) {
            throw new Exception("Illegal Vendor Specific Field length, must at least be 5 to hold vendor id, got only " + value.length);
        }
        this.itsVendorId = new byte[3];
        System.arraycopy(value, 2, this.itsVendorId, 0, 3);
        this.itsVendorData = new byte[value.length - 5];
        System.arraycopy(value, 5, this.itsVendorData, 0, value.length - 5);
        this.setData(CertUtils.appendAt(this.encodeVendor(), this.itsVendorData));
    }

    private byte[] encodeVendor() {
        byte[] vendor = new byte[]{8, 3, this.itsVendorId[0], this.itsVendorId[1], this.itsVendorId[2]};
        return vendor;
    }

    @Override
    public byte[] getValue() {
        return CertUtils.appendAt(this.encodeVendor(), this.itsVendorData);
    }

    @Override
    public String getVendorID() {
        return new Binary2Plaintext(this.itsVendorId).getHexRepresentation();
    }

    @Override
    public String getVendorData() {
        return new Binary2Plaintext(this.itsVendorData).getHexRepresentation();
    }

    @Override
    public void setVendorID(String vendor) throws Exception {
        if (vendor.length() != 6) {
            throw new Exception("Vendor ID must be 3 bytes long.");
        }
        byte[] vendorbytes = new Plaintext2Binary(vendor).getBytes();
        this.itsVendorId = vendorbytes;
        this.setData(CertUtils.appendAt(this.encodeVendor(), this.itsVendorData));
    }

    @Override
    public void setVendorData(byte[] data) throws Exception {
        this.itsVendorData = (byte[])data.clone();
        this.setData(CertUtils.appendAt(this.encodeVendor(), data));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        return this.getVendorID() + "/" + this.getVendorData();
    }

    @Override
    public JPanel showGUI() {
        return new VendorSpecificPanel(this);
    }

    @Override
    public byte[] getTypeAndLength() {
        byte[] retval = new byte[7];
        retval[0] = (byte)this.getType();
        retval[1] = (byte)this.getLength();
        retval[2] = 8;
        retval[3] = 3;
        System.arraycopy(this.itsVendorId, 0, retval, 4, 3);
        return retval;
    }
}

