/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.CACS_ReceiveChannelAssignment;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.CACS_TransmitChannelAssignment;
import java.math.BigInteger;
import java.util.ArrayList;

public class TLV_ChannelAssignmentConfigurationSettings
extends SubTypedTLV {
    public static final int TRANSMIT_CHANNEL_ASSIGNMENT_CONFIGURATION_SETTING = 1;
    public static final int RECEIVE_CHANNEL_ASSIGNMENT_CONFIGURATION_SETTING = 2;
    public static final String typeInfo = "Channel Assignment Configuration Settings";
    public static final String fullTypeInfo = "Channel Assignment Configuration Settings".concat(" (56)");

    public TLV_ChannelAssignmentConfigurationSettings(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(56);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_ChannelAssignmentConfigurationSettings(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(56);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new CACS_TransmitChannelAssignment(this, new BigInteger(value).intValue());
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new CACS_ReceiveChannelAssignment(this, new BigInteger(value).intValue());
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

