/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.SNMPv3ACCESSVIEW_Mask;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.SNMPv3ACCESSVIEW_Name;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.SNMPv3ACCESSVIEW_Subtree;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.SNMPv3ACCESSVIEW_Type;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;

public class TLV_Snmpv3AccessView
extends SubTypedTLV {
    public static final int SNMP_v3_ACCESS_VIEW_NAME = 1;
    public static final int SNMP_v3_ACCESS_VIEW_SUBTREE = 2;
    public static final int SNMP_v3_ACCESS_VIEW_MASK = 3;
    public static final int SNMP_v3_ACCESS_VIEW_TYPE = 4;
    public static final String typeInfo = "SNMPv3 Access View Configuration";
    public static final String fullTypeInfo = "SNMPv3 Access View Configuration".concat(" (54)");

    public TLV_Snmpv3AccessView(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(54);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_Snmpv3AccessView(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(54);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new SNMPv3ACCESSVIEW_Name(this, new String(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new SNMPv3ACCESSVIEW_Subtree(this, ((OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(new ByteArrayInputStream(value))).toString());
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new SNMPv3ACCESSVIEW_Mask(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new SNMPv3ACCESSVIEW_Type(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

