/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.STATICMULTI_CMIMEncoding;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.STATICMULTI_GroupEncoding;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.STATICMULTI_SourceEncoding;
import java.util.ArrayList;

public class TLV_StaticMulticastSessionEncoding
extends SubTypedTLV {
    public static final int STATIC_MULTICAST_GROUP_ENCODING = 1;
    public static final int STATIC_MULTICAST_SOURCE_ENCODING = 2;
    public static final int STATIC_MULTICAST_CMIM_ENCODING = 3;
    public static final String typeInfo = "CMTS Static Multicast Session Encoding";
    public static final String fullTypeInfo = "CMTS Static Multicast Session Encoding".concat(" (64)");

    public TLV_StaticMulticastSessionEncoding(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(64);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_StaticMulticastSessionEncoding(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(64);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new STATICMULTI_GroupEncoding(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new STATICMULTI_SourceEncoding(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new STATICMULTI_CMIMEncoding(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

