/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class TLV_SubscriberMgmtControlMaxCpeIpv6Addresses
extends TLV
implements INumberTlv {
    private static final int minValue = 0;
    private static final int maxValue = 1023;
    private static final int nofBytes = 2;
    public static final String typeInfo = "Subscriber Mgmt Control Max CPE IPv6 Addresses";
    public static final String fullTypeInfo = "Subscriber Mgmt Control Max CPE IPv6 Addresses".concat(" (63)");

    private void initialize(int maxCpe) throws InvalidNumberException, UnsupportedTypeException, InvalidLengthException {
        this.checkConstraints(maxCpe);
        this.setType(63);
        this.setData(this.encode(maxCpe));
    }

    public TLV_SubscriberMgmtControlMaxCpeIpv6Addresses(int maxCpe) throws InvalidLengthException, InvalidNumberException, UnsupportedTypeException {
        this.initialize(maxCpe);
    }

    public TLV_SubscriberMgmtControlMaxCpeIpv6Addresses(byte[] value) throws Exception {
        if (value.length != 2) {
            throw new InvalidLengthException(typeInfo);
        }
        byte[] cpe = new byte[]{value[0], value[1]};
        int maxCpe = this.getIntFromBytes(cpe);
        this.initialize(maxCpe);
    }

    @Override
    public String getShowValue() {
        return Integer.toString(this.getIntFromBytes(this.getValue()));
    }

    private void checkConstraints(int maxCPE) throws InvalidNumberException {
        if (cheatMode) {
            return;
        }
        if (maxCPE < 0 || maxCPE > 1023) {
            throw new InvalidNumberException(this, 0, 1023);
        }
    }

    private byte[] encode(int i) {
        byte[] result = new byte[]{(byte)(i / 256), (byte)(i % 256)};
        return result;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Number of IPv6 prefixes:");
    }

    @Override
    public int getNumber() {
        return this.getIntFromBytes(this.getValue());
    }

    @Override
    public void setNumber(int number) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(number);
        this.setData(this.encode(number));
    }
}

