/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.IIPv6PrefixListTlv;
import com.excentis.security.configfile.panels.basic.Ipv6AddressPrefixListPanel;
import com.excentis.security.configfile.tlvs.docsis30.basic.Inet6WithPrefix;
import java.net.Inet6Address;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TLV_SubscriberMgmtCpeIpv6PrefixList
extends TLV
implements IIPv6PrefixListTlv {
    public static final String typeInfo = "Subscriber Mgmt CPE IPv6 Prefix List";
    public static final String fullTypeInfo = "Subscriber Mgmt CPE IPv6 Prefix List".concat(" (61)");

    public TLV_SubscriberMgmtCpeIpv6PrefixList(ArrayList<Inet6WithPrefix> addresses) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(61);
        this.setAddressPrefixes(addresses);
    }

    public TLV_SubscriberMgmtCpeIpv6PrefixList(byte[] value) throws Exception {
        this.setType(61);
        this.setData(value);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        String result = "";
        for (Inet6WithPrefix adr : this.getAddressPrefixes()) {
            result = result.concat(adr + " ");
        }
        return result;
    }

    public void setAddresses(ArrayList<Inet6Address> addresses) throws InvalidLengthException {
        this.setData(this.getBytesFromIpv6Addresses(addresses));
    }

    @Override
    public JPanel showGUI() {
        return new Ipv6AddressPrefixListPanel(this);
    }

    @Override
    public ArrayList<Inet6WithPrefix> getAddressPrefixes() {
        try {
            return this.getIpv6AddressPrefixesFromBytes(this.getValue());
        }
        catch (Exception e) {
            return new ArrayList<Inet6WithPrefix>();
        }
    }

    @Override
    public void setAddressPrefixes(ArrayList<Inet6WithPrefix> addresses) throws InvalidLengthException {
        this.setData(this.getBytesFromIpv6AddressPrefixes(addresses));
    }
}

