/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.exceptions.docsis30.GroupIDException;
import com.excentis.security.configfile.interfaces.IByteListTlv;
import com.excentis.security.configfile.panels.basic.ByteListPanel;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class TLV_UpstreamDropClassifierGroupId
extends TLV
implements IByteListTlv {
    public static final String typeInfo = "Upstream Drop Classifier Group ID";
    public static final String fullTypeInfo = "Upstream Drop Classifier Group ID".concat(" (62)");

    private void checkConstraints(byte[] ids) throws GroupIDException {
        if (cheatMode) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            int id = 0xFF & ids[i];
            if (id < 1) {
                throw new GroupIDException();
            }
            if (id <= 255) continue;
            throw new GroupIDException();
        }
    }

    private void initialize(byte[] value) throws UnsupportedTypeException, GroupIDException, InvalidLengthException {
        this.setType(62);
        this.checkConstraints(value);
        this.setData(value);
    }

    public TLV_UpstreamDropClassifierGroupId(ArrayList<Byte> addresses) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(62);
        this.setData(this.getBytesArrayFromBytes(addresses));
    }

    public TLV_UpstreamDropClassifierGroupId(byte[] value) throws Exception {
        this.initialize(value);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        String result = "";
        Iterator<Byte> it = this.getBytes().iterator();
        while (it.hasNext()) {
            result = result + it.next() + " ";
        }
        return result;
    }

    @Override
    public JPanel showGUI() {
        return new ByteListPanel(this, "Group IDs:");
    }

    @Override
    public ArrayList<Byte> getBytes() {
        return this.getBytesArrayFromBytes(this.getValue());
    }

    @Override
    public void setBytes(ArrayList<Byte> bytes) throws GroupIDException, InvalidLengthException {
        byte[] byt = this.getBytesArrayFromBytes(bytes);
        this.checkConstraints(byt);
        this.setData(byt);
    }
}

