/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.docsis30.basic;

import com.excentis.security.configfile.exceptions.InvalidLengthException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet6WithPrefix {
    private int prefix;
    private Inet6Address address;

    public Inet6WithPrefix(int prefix, Inet6Address address) {
        this.prefix = prefix;
        this.address = address;
    }

    public Inet6WithPrefix(byte[] value) throws InvalidLengthException, UnknownHostException {
        if (value.length != 17) {
            throw new InvalidLengthException(this.getClass().getSimpleName());
        }
        byte[] addr = new byte[16];
        System.arraycopy(value, 0, addr, 0, 16);
        this.address = (Inet6Address)InetAddress.getByAddress(addr);
        this.prefix = value[16];
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setPrefix(int prefix) {
        this.prefix = prefix;
    }

    public Inet6Address getAddress() {
        return this.address;
    }

    public void setAddress(Inet6Address address) {
        this.address = address;
    }

    public String toString() {
        return "" + this.address.getHostAddress() + "/" + this.prefix;
    }
}

