/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTyped_SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub2types.ETH_DestinationMAC;
import com.excentis.security.configfile.tlvs.tlvsub2types.ETH_EthertypeDsapMacType;
import com.excentis.security.configfile.tlvs.tlvsub2types.ETH_SourceMAC;
import com.excentis.security.tools.Binary2Plaintext;
import java.util.ArrayList;

public class CLAS_EthernetLLCPacketClassification
extends SubTyped_SubTLV {
    public static final String typeInfo = "Ethernet LLC Packet Classification Encodings";
    public static final String fullTypeInfo = "Ethernet LLC Packet Classification Encodings".concat(" (10)");
    public static final int DESTINATION_MAC_ADDRESS = 1;
    public static final int SOURCE_MAC_ADDRESS = 2;
    public static final int ETHERTYPE_DSAP_MACTYPE = 3;

    public CLAS_EthernetLLCPacketClassification(TLV parent, ArrayList<ISubTLV> subTLVs) throws Exception {
        super(parent);
        this.setType(10);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public CLAS_EthernetLLCPacketClassification(TLV parent, byte[] encodedSubTypes) throws Exception {
        super(parent);
        int length;
        this.setType(10);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            Binary2Plaintext b2p;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                b2p = new Binary2Plaintext(value);
                String total = b2p.getHexRepresentation();
                ETH_DestinationMAC sub = new ETH_DestinationMAC(this, total.substring(0, 12), total.substring(12, 24));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                b2p = new Binary2Plaintext(value);
                ETH_SourceMAC sub = new ETH_SourceMAC(this, b2p.getHexRepresentation());
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                ETH_EthertypeDsapMacType sub = new ETH_EthertypeDsapMacType(this, value[0], value[1], value[2]);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

