/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.ClassIDAlreadyUsedException;
import com.excentis.security.configfile.exceptions.ClassIDException;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.sub1panels.DOCS10_ClassIDPanel;
import com.excentis.security.configfile.tlvs.TLV_DOCSIS_1_0_COS;
import javax.swing.JPanel;

public class DOCS10_ClassID
extends SubTLV {
    public static final String typeInfo = "Class ID";
    public static final String fullTypeInfo = "Class ID".concat(" (1)");
    private int itsID = 0;

    public DOCS10_ClassID(TLV parent, int id) throws InvalidLengthException, UnsupportedTypeException, ClassIDException, ClassIDAlreadyUsedException {
        super(parent);
        this.setType(1);
        this.setClassID(id);
    }

    private void checkConstraints(int id) throws ClassIDException, ClassIDAlreadyUsedException {
        if (id < 1) {
            throw new ClassIDException();
        }
        if (id > 16) {
            throw new ClassIDException();
        }
        if (((TLV_DOCSIS_1_0_COS)this.getParent()).used(id)) {
            throw new ClassIDAlreadyUsedException(id);
        }
    }

    public void setClassID(int id) throws ClassIDException, ClassIDAlreadyUsedException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(id);
        }
        this.setData(this.encodeInt1(id));
        ((TLV_DOCSIS_1_0_COS)this.getParent()).removeUsedID(this.itsID);
        ((TLV_DOCSIS_1_0_COS)this.getParent()).addUsedID(id);
        this.itsID = id;
    }

    public int getIntValue() {
        return this.itsID;
    }

    @Override
    public String getShowValue() {
        return "" + this.getIntValue();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new DOCS10_ClassIDPanel(this);
    }
}

