/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class DOCS10_GuaranteedMinUSRate
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Guaranteed Minimum US Channel Data Rate";
    public static final String fullTypeInfo = "Guaranteed Minimum US Channel Data Rate".concat(" (5)");
    private int itsRate = 0;

    public DOCS10_GuaranteedMinUSRate(TLV parent, int usRate) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        super(parent);
        this.setType(5);
        this.setNumber(usRate);
    }

    private void checkConstraints(int rate) throws InvalidNumberException {
        if (rate < 0) {
            throw new InvalidNumberException(this, 0, 10240000);
        }
        if (rate > 10240000) {
            throw new InvalidNumberException(this, 0, 10240000);
        }
    }

    @Override
    public void setNumber(int rate) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(rate);
        this.setData(this.encodeInt4(rate));
        this.itsRate = rate;
    }

    @Override
    public int getNumber() {
        return this.itsRate;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Guaranteed Minimum US Channel Data Rate:");
    }
}

