/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class DOCS10_MaxDSRate
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Maximum Downstream Rate";
    public static final String fullTypeInfo = "Maximum Downstream Rate".concat(" (2)");
    private int itsRate = 0;

    public DOCS10_MaxDSRate(TLV parent, int rate) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        super(parent);
        this.setType(2);
        this.setNumber(rate);
    }

    private void checkConstraints(int channel) throws InvalidNumberException {
        if (channel < 0) {
            throw new InvalidNumberException(this, 0, 55216000);
        }
        if (channel > 55216000) {
            throw new InvalidNumberException(this, 0, 55216000);
        }
    }

    @Override
    public void setNumber(int rate) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(rate);
        this.setData(this.encodeInt4(rate));
        this.itsRate = rate;
    }

    @Override
    public int getNumber() {
        return this.itsRate;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Maximum Downstream Rate:");
    }
}

