/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class DOCS10_MaxUSBurst
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Maximum Upstream Channel Transmit Burst";
    public static final String fullTypeInfo = "Maximum Upstream Channel Transmit Burst".concat(" (6)");
    private int itsBurstSize = 0;

    public DOCS10_MaxUSBurst(TLV parent, int size) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        super(parent);
        this.setType(6);
        this.setNumber(size);
    }

    private void checkConstraints(int size) throws InvalidNumberException {
        if (size < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (size > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int size) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(size);
        this.setData(this.encodeInt2(size));
        this.itsBurstSize = size;
    }

    @Override
    public int getNumber() {
        return this.itsBurstSize;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Maximum Upstream Channel Transmit Burst:");
    }
}

