/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class DOCS10_USChannelPriority
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Upstream Channel Priority";
    public static final String fullTypeInfo = "Upstream Channel Priority".concat(" (4)");
    private int itsPriority = 0;

    public DOCS10_USChannelPriority(TLV parent, int priority) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        super(parent);
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(priority);
        }
        this.setType(4);
        this.setData(new byte[]{(byte)priority});
        this.itsPriority = priority;
    }

    private void checkConstraints(int priority) throws InvalidNumberException {
        if (priority < 0) {
            throw new InvalidNumberException(this, 0, 7);
        }
        if (priority > 7) {
            throw new InvalidNumberException(this, 0, 7);
        }
    }

    @Override
    public void setNumber(int priority) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(priority);
        }
        this.setData(new byte[]{(byte)priority});
        this.itsPriority = priority;
    }

    @Override
    public int getNumber() {
        return this.itsPriority;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Upstream Channel Priority:");
    }
}

