/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class DOCSIS_SYNC_CONFIG_PTPMaxNumberOfClockSlavesConfiguration
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "PTP Max Number of Clock Slaves Configuration";
    public static final String fullTypeInfo = "PTP Max Number of Clock Slaves Configuration".concat(" (3)");
    private int number;

    public DOCSIS_SYNC_CONFIG_PTPMaxNumberOfClockSlavesConfiguration(TLV parent, int number) throws Exception {
        super(parent);
        this.setType(3);
        this.setNumber(number);
    }

    @Override
    public String getShowValue() {
        return String.valueOf(this.number);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Maximum number of slaves (0 = undefined, max range = 1-255): ");
    }

    public int getFrequency() {
        return this.number;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    private void checkConstraints(int n) throws InvalidNumberException {
        if (n < 0) {
            throw new InvalidNumberException(this, 0, 255);
        }
        if (n > 255) {
            throw new InvalidNumberException(this, 0, 255);
        }
    }

    @Override
    public void setNumber(int maxRange) throws InvalidNumberException, InvalidLengthException, InvalidNumberException {
        this.checkConstraints(maxRange);
        this.number = maxRange;
        this.setData(this.encodeInt1(maxRange));
    }
}

