/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.IDropdownTlv;
import com.excentis.security.configfile.panels.basic.DropdownPanel;
import java.util.Arrays;
import javax.swing.JPanel;

public class DOCSIS_SYNC_CONFIG_PTPProfileConfiguration
extends SubTLV
implements IDropdownTlv {
    public static final String typeInfo = "PTP Profile Configuration";
    public static final String fullTypeInfo = "PTP Profile Configuration".concat(" (2)");
    public static String[] profileConfigurations = new String[]{"IEEE-1588 Default profile", "ITU-T G.8265.1", "ITU-T G.8275.1", "ITU-T G.8275.2"};
    private int type;

    public DOCSIS_SYNC_CONFIG_PTPProfileConfiguration(TLV parent, int type) throws Exception {
        super(parent);
        this.setType(2);
        this.setNumber(type);
    }

    private void checkConstraints(int n) throws InvalidNumberException {
        if (n < 0 || n > 3) {
            throw new InvalidNumberException(this, 0, 3);
        }
    }

    public void setNumber(int number) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(number);
        }
        this.type = number;
        this.setData(this.encodeInt1(this.type));
    }

    @Override
    public JPanel showGUI() {
        return new DropdownPanel(this, "PTP Profile Configuration: ", profileConfigurations);
    }

    @Override
    public String getShowValue() {
        return profileConfigurations[this.getNumber()];
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public int getNumber() {
        return this.type;
    }

    @Override
    public void setSelectedValue(String value) throws InvalidNumberException, InvalidLengthException {
        this.setNumber(Arrays.asList(profileConfigurations).indexOf(value));
    }
}

