/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class EROUTER_RATransmissionInterval
extends SubTLV
implements INumberTlv {
    private int itsInterval = 0;
    public static final String typeInfo = "Router Advertisement (RA) Transmission Interval";
    public static final String fullTypeInfo = "Router Advertisement (RA) Transmission Interval".concat(" (10)");

    public EROUTER_RATransmissionInterval(TLV parent, int interval) throws Exception {
        super(parent);
        this.setType(10);
        this.setNumber(interval);
    }

    private void checkConstraints(int interval) throws InvalidNumberException {
        if (interval < 3) {
            throw new InvalidNumberException(this, 3, 1800);
        }
        if (interval > 1800) {
            throw new InvalidNumberException(this, 3, 1800);
        }
    }

    @Override
    public void setNumber(int interval) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(interval);
        }
        this.itsInterval = interval;
        this.setData(this.encodeInt2(this.itsInterval));
    }

    @Override
    public int getNumber() {
        return this.itsInterval;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "RA Transmission Interval:");
    }
}

