/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.IDropdownTlv;
import com.excentis.security.configfile.panels.basic.DropdownPanel;
import javax.swing.JPanel;

public class ESTB_IPModeControl
extends SubTLV
implements IDropdownTlv {
    private int itsInitMode = 0;
    public static final String typeInfo = "eSTB IP Mode Control";
    public static final String fullTypeInfo = "eSTB IP Mode Control".concat(" (1)");
    public static String[] displayMode = new String[]{"IPv4", "IPv6", "Dual-stack Provisioning Mode"};

    public ESTB_IPModeControl(TLV parent, int mode) throws Exception {
        super(parent);
        this.setType(1);
        this.setInitMode(mode);
    }

    private void checkConstraints(int time) throws InvalidNumberException {
        if (time < 0) {
            throw new InvalidNumberException(this, 0, 2);
        }
        if (time > 2) {
            throw new InvalidNumberException(this, 0, 2);
        }
    }

    public void setInitMode(int mode) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(mode);
        }
        this.setData(new byte[]{(byte)mode});
        this.itsInitMode = mode;
    }

    public void setNumber(int i) throws InvalidNumberException, InvalidLengthException {
        this.setInitMode(i);
    }

    @Override
    public int getNumber() {
        return this.itsInitMode;
    }

    @Override
    public String getShowValue() {
        if (this.getNumber() < displayMode.length) {
            return displayMode[this.getNumber()];
        }
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new DropdownPanel(this, "eSTB IP Mode Control:", displayMode);
    }

    @Override
    public void setSelectedValue(String value) throws InvalidNumberException, InvalidLengthException {
        for (int i = 0; i < displayMode.length; ++i) {
            if (!value.equals(displayMode[i])) continue;
            this.setNumber(i);
            return;
        }
    }
}

