/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTyped_SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub2types.SAV_GroupName;
import com.excentis.security.configfile.tlvs.tlvsub2types.SAV_StaticPrefix;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.util.ArrayList;

public class ExtensionField_SavAuthorization
extends SubTyped_SubTLV {
    public static final String typeInfo = "SAV Authorization Encoding";
    public static final String fullTypeInfo = "SAV Authorization Encoding".concat(" (7)");
    public static final int SAV_GROUP_NAME = 1;
    public static final int SAV_STATIC_PREFIX = 2;

    public ExtensionField_SavAuthorization(TLV parent, ArrayList<ISubTLV> subTLVs) throws Exception {
        super(parent);
        this.setType(7);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public ExtensionField_SavAuthorization(TLV parent, byte[] encodedSubTypes) throws Exception {
        super(parent);
        int length;
        this.setType(7);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new SAV_GroupName(this, new String(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new SAV_StaticPrefix(this, this.decodeSavPrefix(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    private String decodeSavPrefix(byte[] encoded_prefix) throws Exception {
        int pointer = 0;
        if (encoded_prefix[pointer] != 1) {
            throw new Exception("SAV static prefix must contain address (subtype 1), found " + encoded_prefix[pointer]);
        }
        int len = encoded_prefix[++pointer];
        ++pointer;
        if (len != 4 && len != 16) {
            throw new Exception("SAV static prefix addres must be 4 (ipv4) or 16 (ipv6) bytes long, found length " + encoded_prefix[pointer]);
        }
        byte[] addr = new byte[len];
        for (int i = 0; i < len; ++i) {
            addr[i] = encoded_prefix[pointer++];
        }
        String addrstr = "";
        addrstr = len == 4 ? Inet4Address.getByAddress(addr).getHostAddress() : Inet6Address.getByAddress(addr).getHostAddress();
        if (encoded_prefix[pointer] != 2) {
            throw new Exception("SAV static prefix must contain prefix (subtype ), found " + encoded_prefix[pointer]);
        }
        if (encoded_prefix[++pointer] != 1) {
            throw new Exception("SAV static prefix lengh must be 1, found " + encoded_prefix[pointer]);
        }
        byte prefix = encoded_prefix[++pointer];
        return addrstr + "/" + prefix;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

