/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IAddressTlv;
import com.excentis.security.configfile.panels.basic.Ipv4OrIpv6AddressPanel;
import com.excentis.security.tools.Binary2Plaintext;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import javax.swing.JPanel;

public class PTPAC_CMTSPTPIPAddressConfiguration
extends SubTLV
implements IAddressTlv {
    public static final String typeInfo = "CMTS PTP IP Address Configuration";
    public static final String fullTypeInfo = "CMTS PTP IP Address Configuration".concat(" (2)");

    public PTPAC_CMTSPTPIPAddressConfiguration(TLV parent, byte[] address) throws Exception {
        super(parent);
        this.setType(2);
        this.setAddress(address);
    }

    private void checkConstraints(byte[] value) throws Exception {
        if (value.length != 4 && value.length != 16) {
            throw new Exception("Address must be 4 (IPv4) or 16 (IPv6) bytes long.");
        }
    }

    @Override
    public void setAddress(byte[] value) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(value);
        }
        this.setData(value);
    }

    @Override
    public String getAddress() {
        return this.getShowValue();
    }

    @Override
    public String getShowValue() {
        byte[] address = this.getValue();
        try {
            if (address.length == 4) {
                return Inet4Address.getByAddress(address).getHostAddress();
            }
            if (address.length == 16) {
                return Inet6Address.getByAddress(address).getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new Ipv4OrIpv6AddressPanel(this);
    }
}

