/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IMACTlv;
import com.excentis.security.configfile.panels.basic.MACPanel;
import com.excentis.security.configfile.parser.ValueParser;
import com.excentis.security.tools.Plaintext2Binary;
import javax.swing.JPanel;

public class PTPAC_PTPDestinationMulticastMACAddressConfiguration
extends SubTLV
implements IMACTlv {
    public static final String typeInfo = "PTP Destination Multicast MAC Address Configuration";
    public static final String fullTypeInfo = "PTP Destination Multicast MAC Address Configuration".concat(" (3)");
    private String itsMac = null;
    private MACPanel panel = null;

    public PTPAC_PTPDestinationMulticastMACAddressConfiguration(TLV parent, String s) throws Exception {
        super(parent);
        this.setType(3);
        this.setMACAddress(s);
    }

    public String getMac() {
        return this.itsMac;
    }

    @Override
    public String getShowValue() {
        return "MAC " + this.itsMac;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        this.panel = new MACPanel(this, this.itsMac);
        return this.panel;
    }

    @Override
    public String getMACAddress() {
        return this.itsMac;
    }

    @Override
    public void setMACAddress(String addr) throws Exception {
        addr = ValueParser.filterMACAddress(addr);
        ValueParser.checkMACConstraints(addr);
        this.itsMac = addr;
        if (this.panel != null) {
            this.panel.refreshPanel(addr);
        }
        this.setData(new Plaintext2Binary(this.itsMac).getBytes());
    }
}

