/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_AggregateSFReference
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Aggregate Service Flow Reference";
    public static final String fullTypeInfo = "Aggregate Service Flow Reference".concat(" (36)");
    private int itsReference = -1;

    public SF_AggregateSFReference(TLV parent, int reference) throws Exception {
        super(parent);
        this.setType(36);
        this.setNumber(reference);
    }

    private void checkConstraints(int reference) throws InvalidNumberException {
        if (reference < 1) {
            throw new InvalidNumberException(this, 1, 65535);
        }
        if (reference > 65535) {
            throw new InvalidNumberException(this, 1, 65535);
        }
    }

    @Override
    public void setNumber(int ref) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(ref);
        }
        this.setData(this.encodeInt2(ref));
        this.itsReference = ref;
    }

    @Override
    public int getNumber() {
        return this.itsReference;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsReference;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Aggregate SF Reference:");
    }
}

