/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_ApplicationIdentifier
extends SubTLV
implements ILongNumberTlv {
    private long itsApplicationId = 0L;
    public static final String typeInfo = "Application Identifier";
    public static final String fullTypeInfo = "Application Identifier".concat(" (34)");

    public SF_ApplicationIdentifier(TLV parent, long appid) throws Exception {
        super(parent);
        this.setType(34);
        this.setLongNumber(appid);
    }

    private void checkConstraints(long appid) throws InvalidLongNumberException {
        if (appid < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (appid > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long appid) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(appid);
        }
        this.setData(this.encodeLong(appid));
        this.itsApplicationId = appid;
    }

    @Override
    public long getLongNumber() {
        return this.itsApplicationId;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsApplicationId;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Application Id:");
    }
}

