/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_AssumedMinimumReservedRatePacketSize
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Assumed Minimum Reserved Rate Packet Size";
    public static final String fullTypeInfo = "Assumed Minimum Reserved Rate Packet Size".concat(" (11)");
    private int itsRatePacketSize = 0;

    public SF_AssumedMinimumReservedRatePacketSize(TLV parent, int rate) throws Exception {
        super(parent);
        this.setType(11);
        this.setNumber(rate);
    }

    private void checkConstraints(long rate) throws InvalidNumberException {
        if (rate < 0L) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (rate > 65535L) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int rate) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(rate);
        }
        this.setData(this.encodeInt2(rate));
        this.itsRatePacketSize = rate;
    }

    @Override
    public int getNumber() {
        return this.itsRatePacketSize;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsRatePacketSize;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Packet Size:");
    }
}

