/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_DownstreamResequencing
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Downstream Resequencing";
    public static final String fullTypeInfo = "Downstream Resequencing".concat(" (17)");
    private int itsSequencing = 0;

    public SF_DownstreamResequencing(TLV parent, int sequencing) throws Exception {
        super(parent);
        this.setType(17);
        this.setNumber(sequencing);
    }

    private void checkConstraints(int sequencing) throws InvalidNumberException {
        if (sequencing != 0 && sequencing != 1) {
            throw new InvalidNumberException(this, 0, 1);
        }
    }

    @Override
    public void setNumber(int sequencing) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(sequencing);
        }
        this.setData(new byte[]{(byte)sequencing});
        this.itsSequencing = sequencing;
    }

    @Override
    public int getNumber() {
        return this.itsSequencing;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsSequencing;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Resequencing (0/1):");
    }
}

