/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTyped_SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub2types.EHQOS_SFIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub2types.EHQOS_SFPriority;
import com.excentis.security.configfile.tlvs.tlvsub2types.EHQOS_SFReference;
import com.excentis.security.configfile.tlvs.tlvsub2types.EHQOS_SFSCN;
import com.excentis.security.configfile.tlvs.tlvsub2types.EHQOS_SFWeight;
import java.util.ArrayList;

public class SF_EHQoSEncodings
extends SubTyped_SubTLV {
    public static final int CONSTITUENT_SF_REFERENCE = 1;
    public static final int CONSTITUENT_SF_IDENTIFIER = 2;
    public static final int CONSTITUENT_SF_SCN = 3;
    public static final int CONSTITUENT_SF_PRIORITY = 4;
    public static final int CONSTITUENT_SF_WEIGHT = 5;
    public static final String typeInfo = "Enhanced HQoS Intra-ASF Scheduling Encoding";
    public static final String fullTypeInfo = "Enhanced HQoS Intra-ASF Scheduling Encoding".concat(" (47)");

    public SF_EHQoSEncodings(TLV parent, ArrayList<ISubTLV> subTLVs) throws Exception {
        super(parent);
        this.setType(47);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public SF_EHQoSEncodings(TLV parent, byte[] encodedSubTypes) throws Exception {
        super(parent);
        int length;
        this.setType(47);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new EHQOS_SFReference(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new EHQOS_SFIdentifier(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new EHQOS_SFSCN(this, this.decodeStringMinusLast(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new EHQOS_SFPriority(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new EHQOS_SFWeight(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

