/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_GrantsPerInterval
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Grants per Interval";
    public static final String fullTypeInfo = "Grants per Interval".concat(" (22)");
    private int itsGrants = 0;

    public SF_GrantsPerInterval(TLV parent, int grants) throws Exception {
        super(parent);
        this.setType(22);
        this.setNumber(grants);
    }

    private void checkConstraints(int size) throws InvalidNumberException {
        if (size < 0) {
            throw new InvalidNumberException(this, 0, 127);
        }
        if (size > 127) {
            throw new InvalidNumberException(this, 0, 127);
        }
    }

    @Override
    public void setNumber(int grants) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(grants);
        }
        this.setData(new byte[]{(byte)grants});
        this.itsGrants = grants;
    }

    @Override
    public int getNumber() {
        return this.itsGrants;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsGrants;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Grants:");
    }
}

