/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_GuaranteedGrantInterval
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Guaranteed Grant Interval";
    public static final String fullTypeInfo = "Guaranteed Grant Interval".concat(" (44)");
    private int itsSize = 0;

    public SF_GuaranteedGrantInterval(TLV parent, int size) throws Exception {
        super(parent);
        this.setType(44);
        this.setNumber(size);
    }

    private void checkConstraints(int size) throws InvalidNumberException {
        if (size < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (size > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int size) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(size);
        }
        this.setData(this.encodeInt2(size));
        this.itsSize = size;
    }

    @Override
    public int getNumber() {
        return this.itsSize;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsSize;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Guaranteed Grant Interval (microseconds):");
    }
}

