/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_GuaranteedGrantRate
extends SubTLV
implements ILongNumberTlv {
    public static final String typeInfo = "Guaranteed Grant Rate";
    public static final String fullTypeInfo = "Guaranteed Grant Rate".concat(" (45)");
    private long itsRate = 0L;

    public SF_GuaranteedGrantRate(TLV parent, long rate) throws Exception {
        super(parent);
        this.setType(45);
        this.setLongNumber(rate);
    }

    private void checkConstraints(long rate) throws InvalidLongNumberException {
        if (rate < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (rate > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long rate) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(rate);
        }
        this.setData(this.encodeLong(rate));
        this.itsRate = rate;
    }

    @Override
    public long getLongNumber() {
        return this.itsRate;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsRate;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Guaranteed Grant Rate (bits/s):");
    }
}

