/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_MaxConcatenatedBurst
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Maximum Concatenated Burst";
    public static final String fullTypeInfo = "Maximum Concatenated Burst".concat(" (14)");
    private int itsBurst = 0;

    public SF_MaxConcatenatedBurst(TLV parent, int burst) throws Exception {
        super(parent);
        this.setType(14);
        this.setNumber(burst);
    }

    private void checkConstraints(long burst) throws InvalidNumberException {
        if (burst < 0L) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (burst > 65535L) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int burst) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(burst);
        }
        this.setData(this.encodeInt2(burst));
        this.itsBurst = burst;
    }

    @Override
    public int getNumber() {
        return this.itsBurst;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsBurst;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Burst Size:");
    }
}

