/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_MaxTrafficBurst
extends SubTLV
implements ILongNumberTlv {
    public static final String typeInfo = "Maximum Traffic Burst";
    public static final String fullTypeInfo = "Maximum Traffic Burst".concat(" (9)");
    private long itsBurst = 0L;

    public SF_MaxTrafficBurst(TLV parent, long burst) throws Exception {
        super(parent);
        this.setType(9);
        this.setLongNumber(burst);
    }

    private void checkConstraints(long rate) throws InvalidLongNumberException {
        if (rate < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (rate > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long burst) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(burst);
        }
        this.setData(this.encodeLong(burst));
        this.itsBurst = burst;
    }

    @Override
    public long getLongNumber() {
        return this.itsBurst;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsBurst;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Burst Size (bytes):");
    }
}

