/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_MaximumDownstreamLatency
extends SubTLV
implements ILongNumberTlv {
    public static final String typeInfo = "Maximum Downstream Latency";
    public static final String fullTypeInfo = "Maximum Downstream Latency".concat(" (14)");
    private long itsLatency = 0L;

    public SF_MaximumDownstreamLatency(TLV parent, long latency) throws Exception {
        super(parent);
        this.setType(14);
        this.setLongNumber(latency);
    }

    private void checkConstraints(long latency) throws InvalidLongNumberException {
        if (latency < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (latency > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long latency) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(latency);
        }
        this.setData(this.encodeLong(latency));
        this.itsLatency = latency;
    }

    @Override
    public long getLongNumber() {
        return this.itsLatency;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsLatency;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Latency (microseconds):");
    }
}

