/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_MultiplierToContentionRequestBackoffWindow
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Multiplier to Contention Request Backoff Window";
    public static final String fullTypeInfo = "Multiplier to Contention Request Backoff Window".concat(" (25)");
    private int itsMultiplier = 0;

    public SF_MultiplierToContentionRequestBackoffWindow(TLV parent, int multiplier) throws Exception {
        super(parent);
        this.setType(25);
        this.setNumber(multiplier);
    }

    private void checkConstraints(int multiplier) throws InvalidNumberException {
        if (multiplier < 4) {
            throw new InvalidNumberException(this, 4, 12);
        }
        if (multiplier > 12) {
            throw new InvalidNumberException(this, 4, 12);
        }
    }

    @Override
    public void setNumber(int multiplier) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(multiplier);
        }
        this.setData(new byte[]{(byte)multiplier});
        this.itsMultiplier = multiplier;
    }

    @Override
    public int getNumber() {
        return this.itsMultiplier;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsMultiplier;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Multiplier:");
    }
}

