/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_NominalPollingInterval
extends SubTLV
implements ILongNumberTlv {
    public static final String typeInfo = "Nominal Polling Interval";
    public static final String fullTypeInfo = "Nominal Polling Interval".concat(" (17)");
    private long itsInterval = 0L;

    public SF_NominalPollingInterval(TLV parent, long interval) throws Exception {
        super(parent);
        this.setType(17);
        this.setLongNumber(interval);
    }

    private void checkConstraints(long rate) throws InvalidLongNumberException {
        if (rate < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (rate > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long interval) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(interval);
        }
        this.setData(this.encodeLong(interval));
        this.itsInterval = interval;
    }

    @Override
    public long getLongNumber() {
        return this.itsInterval;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsInterval;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Polling interval (microseconds):");
    }
}

