/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub1panels.SF_QoSSetPanel;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_UpstreamServiceFlow;
import javax.swing.JPanel;

public class SF_QoSSet
extends SubTLV {
    public static final String typeInfo = "Quality of Service Parameter Set";
    public static final String fullTypeInfo = "Quality of Service Parameter Set".concat(" (6)");
    private boolean provisioned = false;
    private boolean admitted = false;
    private boolean active = false;

    public SF_QoSSet(TLV parent, boolean prov, boolean adm, boolean act) throws Exception {
        super(parent);
        boolean upstream = this.getParent() instanceof TLV_UpstreamServiceFlow;
        int ref = ((TLV_ServiceFlow)parent).getReference();
        if (ref != -1 && !((TLV_ServiceFlow)parent).getConfigFile().checkUsedRef(ref, new boolean[]{prov, adm, act}, upstream)) {
            throw new Exception("Error: Unable to set QoS params for Service Flow Reference " + ref);
        }
        this.setType(6);
        this.setData(this.encode(prov, adm, act));
        this.provisioned = prov;
        this.admitted = adm;
        this.active = act;
        if (ref != -1) {
            ((TLV_ServiceFlow)parent).getConfigFile().updateUsedRef(ref);
        }
    }

    public void setProvisioned(boolean prov) throws Exception {
        if (prov == this.provisioned) {
            return;
        }
        int ref = ((TLV_ServiceFlow)this.getParent()).getReference();
        if (ref != -1) {
            boolean upstream;
            boolean bl = upstream = this.getParent() instanceof TLV_UpstreamServiceFlow;
            if (!((TLV_ServiceFlow)this.getParent()).getConfigFile().checkUsedRef(ref, new boolean[]{prov, false, false}, upstream)) {
                throw new Exception("Error: Unable to set QoS param provisioned for Service Flow Reference " + ref);
            }
        }
        this.provisioned = prov;
        this.setData(this.encode(this.provisioned, this.admitted, this.active));
        if (ref != -1) {
            ((TLV_ServiceFlow)this.getParent()).getConfigFile().updateUsedRef(ref);
        }
    }

    public void setAdmitted(boolean adm) throws Exception {
        if (adm == this.admitted) {
            return;
        }
        int ref = ((TLV_ServiceFlow)this.getParent()).getReference();
        if (ref != -1) {
            boolean upstream;
            boolean bl = upstream = this.getParent() instanceof TLV_UpstreamServiceFlow;
            if (!((TLV_ServiceFlow)this.getParent()).getConfigFile().checkUsedRef(ref, new boolean[]{false, adm, false}, upstream)) {
                throw new Exception("Error: Unable to set QoS param provisioned for Service Flow Reference " + ref);
            }
        }
        this.admitted = adm;
        this.setData(this.encode(this.provisioned, this.admitted, this.active));
        if (ref != -1) {
            ((TLV_ServiceFlow)this.getParent()).getConfigFile().updateUsedRef(ref);
        }
    }

    public void setActive(boolean act) throws Exception {
        if (act == this.active) {
            return;
        }
        int ref = ((TLV_ServiceFlow)this.getParent()).getReference();
        if (ref != -1) {
            boolean upstream;
            boolean bl = upstream = this.getParent() instanceof TLV_UpstreamServiceFlow;
            if (!((TLV_ServiceFlow)this.getParent()).getConfigFile().checkUsedRef(ref, new boolean[]{false, false, act}, upstream)) {
                throw new Exception("Error: Unable to set QoS param provisioned for Service Flow Reference " + ref);
            }
        }
        this.active = act;
        this.setData(this.encode(this.provisioned, this.admitted, this.active));
        if (ref != -1) {
            ((TLV_ServiceFlow)this.getParent()).getConfigFile().updateUsedRef(ref);
        }
    }

    public boolean getProvisioned() {
        return this.provisioned;
    }

    public boolean getAdmitted() {
        return this.admitted;
    }

    public boolean getActive() {
        return this.active;
    }

    @Override
    public String getShowValue() {
        return "" + (this.provisioned ? "provisioned " : "") + (this.admitted ? "admitted " : "") + (this.active ? "active" : "");
    }

    public byte[] encode(boolean pro, boolean adm, boolean act) {
        if (pro) {
            if (adm) {
                if (act) {
                    return new byte[]{7};
                }
                return new byte[]{3};
            }
            if (act) {
                return new byte[]{5};
            }
            return new byte[]{1};
        }
        if (adm) {
            if (act) {
                return new byte[]{6};
            }
            return new byte[]{2};
        }
        if (act) {
            return new byte[]{4};
        }
        return new byte[]{0};
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new SF_QoSSetPanel(this);
    }
}

