/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub1panels.SF_ReferencePanel;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_UpstreamServiceFlow;
import javax.swing.JPanel;

public class SF_Reference
extends SubTLV {
    public static final String typeInfo = "Service Flow Reference";
    public static final String fullTypeInfo = "Service Flow Reference".concat(" (1)");
    private int itsReference = -1;

    public SF_Reference(TLV parent, int reference) throws Exception {
        super(parent);
        this.setType(1);
        this.setReference(reference);
    }

    private void checkConstraints(int reference) throws Exception {
        boolean upstream;
        if (reference < 1) {
            throw new Exception("Reference must be between 1 and 65535");
        }
        if (reference > 65535) {
            throw new Exception("Reference must be between 1 and 65535");
        }
        boolean[] qos = ((TLV_ServiceFlow)this.getParent()).getQosSettings();
        boolean bl = upstream = this.getParent() instanceof TLV_UpstreamServiceFlow;
        if (!((TLV_ServiceFlow)this.getParent()).getConfigFile().checkUsedRef(reference, qos, upstream)) {
            throw new Exception("Reference cannot be used with current QoS settings.");
        }
    }

    public void setReference(int ref) throws Exception {
        if (ref == this.itsReference) {
            return;
        }
        int oldref = this.itsReference;
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(ref);
        }
        this.setData(this.encodeInt2(ref));
        this.itsReference = ref;
        ((TLV_ServiceFlow)this.getParent()).getConfigFile().updateUsedRef(oldref);
        ((TLV_ServiceFlow)this.getParent()).getConfigFile().updateUsedRef(ref);
    }

    public int getReference() {
        return this.itsReference;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsReference;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new SF_ReferencePanel(this);
    }
}

