/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SF_TimeoutForActiveQoS
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Timeout for Active QoS Parameters";
    public static final String fullTypeInfo = "Timeout for Active QoS Parameters".concat(" (12)");
    private int itsTimeout = 0;

    public SF_TimeoutForActiveQoS(TLV parent, int time) throws Exception {
        super(parent);
        this.setType(12);
        this.setNumber(time);
    }

    private void checkConstraints(int time) throws InvalidNumberException {
        if (time < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (time > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int time) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(time);
        }
        this.setData(this.encodeInt2(time));
        this.itsTimeout = time;
    }

    @Override
    public int getNumber() {
        return this.itsTimeout;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsTimeout;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Timeout (seconds):");
    }
}

