/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_ToleratedGrantJitter
extends SubTLV
implements ILongNumberTlv {
    public static final String typeInfo = "Tolerated Grant Jitter";
    public static final String fullTypeInfo = "Tolerated Grant Jitter".concat(" (21)");
    private long itsJitter = 0L;

    public SF_ToleratedGrantJitter(TLV parent, long jitter) throws Exception {
        super(parent);
        this.setType(21);
        this.setLongNumber(jitter);
    }

    private void checkConstraints(long jitter) throws InvalidLongNumberException {
        if (jitter < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (jitter > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long jitter) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(jitter);
        }
        this.setData(this.encodeLong(jitter));
        this.itsJitter = jitter;
    }

    @Override
    public long getLongNumber() {
        return this.itsJitter;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsJitter;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Jitter:");
    }
}

