/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class SF_UnsolicitedGrantTimeReference
extends SubTLV
implements ILongNumberTlv {
    public static final String typeInfo = "Unsolicited Grant Time Reference";
    public static final String fullTypeInfo = "Unsolicited Grant Time Reference".concat(" (24)");
    private long itsTimeRef = 0L;

    public SF_UnsolicitedGrantTimeReference(TLV parent, long timeref) throws Exception {
        super(parent);
        this.setType(24);
        this.setLongNumber(timeref);
    }

    private void checkConstraints(long timeref) throws InvalidLongNumberException {
        if (timeref < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (timeref > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long timeref) throws InvalidLongNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(timeref);
        }
        this.setData(this.encodeLong(timeref));
        this.itsTimeRef = timeref;
    }

    @Override
    public long getLongNumber() {
        return this.itsTimeRef;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsTimeRef;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Time Reference (count):");
    }
}

