/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IStringTlv;
import com.excentis.security.configfile.panels.basic.StringPanel;
import javax.swing.JPanel;

public class SNMPV3_SecurityName
extends SubTLV
implements IStringTlv {
    public static final String typeInfo = "Snmp V3 Kickstart Security Name";
    public static final String fullTypeInfo = "Snmp V3 Kickstart Security Name".concat(" (1)");
    private String itsName = "";

    public SNMPV3_SecurityName(TLV parent, String secname) throws Exception {
        super(parent);
        this.setType(1);
        this.setStringValue(secname);
    }

    private void checkConstraints(String s) throws Exception {
        if (s.length() < 2) {
            throw new Exception("Security Name length must be between 2 and 16 characters.");
        }
        if (s.length() > 16) {
            throw new Exception("Security Name length must be between 2 and 16 characters.");
        }
    }

    @Override
    public String getShowValue() {
        return this.itsName;
    }

    @Override
    public void setStringValue(String name) throws Exception {
        this.checkConstraints(name);
        this.setData(name.getBytes());
        this.itsName = name;
    }

    @Override
    public String getStringValue() {
        return this.itsName;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new StringPanel(this, "Security Name:");
    }
}

